/* Copyright (c) 2004, 2005, Oracle. All rights reserved.  */

/*

   NAME
     insert1.c - <one-line expansion of the name>

   DESCRIPTION
     <short description of facility this file declares/defines>

   EXPORT FUNCTION(S)
     <external functions defined for use outside package - one-line description>

   INTERNAL FUNCTION(S)
     <other external functions defined - one-line descriptions>

   STATIC FUNCTION(S)
     <static functions defined - one-line descriptions>

   NOTES
     <other useful comments, qualifications, etc.>

   MODIFIED   (MM/DD/YY)
   sprabhak    07/17/05 - Error handling
   ardesai     03/04/05 - Include windows.h for windows platform.
   subanerj    06/06/04 - subanerj_odbc_env_setup
   ardesai     06/02/04 - Creation

*/

#ifdef WIN32COMMON
#include <windows.h>
#endif

#include <stdio.h>
#include <sql.h>
#include <sqlext.h>
#define  STR_LEN 30

int main ()
{
  HENV          henv;              /* environment handle */
  HDBC          hdbc;              /* connection handle */
  HSTMT         hstmt;             /* statement handle */
  SDWORD        retcode;           /* return code */
  SQLCHAR *     stmt = "insert into emp(empno, sal) values (953,8989)";
  SQLCHAR       ename[40] = "Rama";
  SQLUINTEGER   empno = 111, sal = 2222;
  SQLINTEGER    enameInd, salInd, enoInd;
  SQLCHAR       SqlState[6], Msg[SQL_MAX_MESSAGE_LENGTH];
  SQLINTEGER    NativeError;
  SQLSMALLINT   MsgLen;

  retcode = SQLAllocEnv (&henv);
  retcode = SQLSetEnvAttr (henv, SQL_ATTR_ODBC_VERSION, (void *) SQL_OV_ODBC3,
              SQL_IS_INTEGER);
  retcode = SQLAllocConnect (henv, &hdbc);

  retcode = SQLConnect (hdbc, "TestDBDSN", SQL_NTS, "scott", SQL_NTS, "tiger",
              SQL_NTS);
  if (retcode != SQL_SUCCESS)
    {
      retcode = SQLGetDiagRec (SQL_HANDLE_DBC, hdbc, 1,
                  SqlState, &NativeError, Msg, sizeof (Msg), &MsgLen);
      printf ("SqlState = %s\n Message = %s\n", SqlState, Msg);
      goto EXIT;
    }
  retcode = SQLAllocHandle (SQL_HANDLE_STMT, hdbc, &hstmt);
  retcode = SQLPrepare (hstmt, stmt, SQL_NTS);
  if (retcode != SQL_SUCCESS)
    {
      retcode = SQLGetDiagRec (SQL_HANDLE_STMT, hstmt, 1,
                  SqlState, &NativeError, Msg, sizeof (Msg), &MsgLen);
      printf ("SqlState = %s\n Message = %s\n", SqlState, Msg);
      goto EXIT;
    }

  retcode = SQLExecute (hstmt);
  if (retcode != SQL_SUCCESS)
    {
      retcode = SQLGetDiagRec (SQL_HANDLE_STMT, hstmt, 1,
                  SqlState, &NativeError, Msg, sizeof (Msg), &MsgLen);
      printf ("SqlState = %s\n Message = %s\n", SqlState, Msg);
      goto EXIT;
    }
  SQLEndTran (SQL_HANDLE_ENV, henv, SQL_COMMIT);
  printf ("Insert is successful with empno 953 and sal 8989\n");

EXIT:
  SQLFreeStmt (hstmt, SQL_CLOSE);
  SQLDisconnect (hdbc);
  SQLFreeConnect (hdbc);
  SQLFreeEnv (henv);
  return 0;
}


/* end of file insert1.c */
